function y = normcdfmht(x,mu,sigma)
%NORMCDFMHT   Normal cumulative distribution function (cdf).
%   NORMCDFMHT(X,MU,SIGMA) returns the cdf of the normal distribution with
%   mean MU and standard deviation SIGMA, evaluated at the values in X.
%   It is an alternative function to NORMCDF from the Stats Toolbox. It
%   uses the equation to calculate the CDF of the normal distribution.

% by Martin H. Trauth, 18 November 2020 http://mres.uni-potsdam.de

for i = 1 : length(x)
    y(i) = (1/(sigma*(2*pi).^0.5)).* sum(exp(-0.5*((x(i)-mu)/sigma).^2));
end
y = cumsum(y);
y = y/max(y);

y = reshape(y,size(x));
